package ru.yandex.solomon.expression.analytics;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstStatement;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProgramWithReturn {

    private final List<AstStatement> statements;
    private final Ast expr;

    public ProgramWithReturn(List<AstStatement> statements, Ast expr) {
        this.statements = statements;
        this.expr = expr;
    }

    public Ast getExpr() {
        return expr;
    }

    public List<AstStatement> getStatements() {
        return statements;
    }
}
