package ru.yandex.solomon.expression.analytics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.SelParser;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstAssignment;
import ru.yandex.solomon.expression.ast.AstStatement;
import ru.yandex.solomon.expression.compile.DeprOpts;
import ru.yandex.solomon.expression.version.SelVersion;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
class ProgramWithReturnCompiler extends AbstractCompiler {
    ProgramWithReturnCompiler(SelVersion version, String src, boolean useNewFormat) {
        super(version, src);
        this.withDeprOpts(DeprOpts.DATA_API);
        this.useNewFormat(useNewFormat);
    }

    ProgramWithReturnCompiler(SelVersion version, String src, DeprOpts deprOpts, boolean useNewFormat) {
        super(version, src);
        this.withDeprOpts(deprOpts);
        this.useNewFormat(useNewFormat);
    }

    @Override
    public Program compileInternal() {
        ProgramWithReturn programWithReturn = new SelParser(source).parseProgramWithReturn();

        String exprVar = "external$0";
        HashMap<String, String> expressionsToVariableNames = new HashMap<>();
        expressionsToVariableNames.put(source, exprVar);

        Ast returnExpr = programWithReturn.getExpr();
        AstAssignment returnAst = new AstAssignment(returnExpr.getRange(), exprVar, returnExpr);

        List<AstStatement> statements = new ArrayList<>(programWithReturn.getStatements());
        statements.add(returnAst);

        return compileStatements(statements, expressionsToVariableNames);
    }
}
