package ru.yandex.solomon.expression.ast;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class Ast {
    private final PositionRange range;

    Ast(PositionRange range) {
        this.range = range;
    }

    public abstract Ast withRange(PositionRange range);
    public abstract Ast stripRanges();

    public PositionRange getRange() {
        return range;
    }

    @Override
    public abstract String toString();

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Ast ast = (Ast) o;
        return range.equals(ast.range);
    }

    @Override
    public int hashCode() {
        return range.hashCode();
    }

    public AstLambda lambda() {
        return (AstLambda) this;
    }
}
