package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstAnonymous extends AstStatement {

    private final Ast expr;

    public AstAnonymous(PositionRange range, Ast expr) {
        super(range);
        this.expr = expr;
    }

    public Ast getExpr() {
        return expr;
    }

    @Override
    public AstAnonymous withRange(PositionRange range) {
        return new AstAnonymous(range, expr);
    }

    @Override
    public AstAnonymous stripRanges() {
        return new AstAnonymous(PositionRange.UNKNOWN, expr.stripRanges());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstAnonymous that = (AstAnonymous) o;
        return expr.equals(that.expr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), expr);
    }

    @Override
    public String toString() {
        return expr.toString();
    }

}
