package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstAssignment extends AstStatement {

    private final String ident;
    private final Ast expr;

    public AstAssignment(PositionRange range, String ident, Ast expr) {
        super(range);
        this.ident = ident;
        this.expr = expr;
    }

    @Override
    public AstAssignment withRange(PositionRange range) {
        return new AstAssignment(range, ident, expr);
    }

    @Override
    public AstAssignment stripRanges() {
        return new AstAssignment(PositionRange.UNKNOWN, ident, expr.stripRanges());
    }

    public String getIdent() {
        return ident;
    }

    public Ast getExpr() {
        return expr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstAssignment that = (AstAssignment) o;
        return ident.equals(that.ident) &&
                expr.equals(that.expr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ident, expr);
    }

    @Override
    public String toString() {
        return "let " + ident + " = " + expr.toString();
    }

}
