package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstBinOp extends Ast {
    private final Ast left;
    private final Ast right;
    private final AstOp op;

    public AstBinOp(PositionRange range, Ast left, Ast right, AstOp op) {
        super(range);
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public AstBinOp withRange(PositionRange range) {
        return new AstBinOp(range, left, right, op);
    }

    @Override
    public AstBinOp stripRanges() {
        return new AstBinOp(PositionRange.UNKNOWN, left.stripRanges(), right.stripRanges(), op.stripRanges());
    }

    public Ast getLeft() {
        return left;
    }

    public Ast getRight() {
        return right;
    }

    public AstOp getOp() {
        return op;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstBinOp astBinOp = (AstBinOp) o;
        return left.equals(astBinOp.left) &&
                right.equals(astBinOp.right) &&
                op.equals(astBinOp.op);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), left, right, op);
    }

    @Override
    public String toString() {
        return "AstBinOp{" +
                "left=" + left +
                ", right=" + right +
                ", op='" + op + '\'' +
                "}@" + getRange();
    }

}
