package ru.yandex.solomon.expression.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstCall extends Ast {
    public final AstIdent func;
    public final List<Ast> args;

    public AstCall(PositionRange range, AstIdent func, List<Ast> args) {
        super(range);
        this.func = func;
        this.args = args;
    }

    @Override
    public AstCall withRange(PositionRange range) {
        return new AstCall(range, func, args);
    }

    @Override
    public AstCall stripRanges() {
        List<Ast> strippedArgs = args.stream().map(Ast::stripRanges).collect(Collectors.toList());
        return new AstCall(PositionRange.UNKNOWN, func.stripRanges(), strippedArgs);
    }

    public AstIdent getFunc() {
        return func;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstCall astCall = (AstCall) o;
        return func.equals(astCall.func) &&
                args.equals(astCall.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), func, args);
    }

    @Override
    public String toString() {
        return func.getIdent() + args.stream()
            .map(Ast::toString)
            .collect(Collectors.joining(", ", "(", ")"));
    }
}
