package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstIdent extends Ast {
    private final String ident;

    public AstIdent(PositionRange range, String ident) {
        super(range);
        this.ident = ident;
    }

    @Override
    public AstIdent withRange(PositionRange range) {
        return new AstIdent(range, ident);
    }

    @Override
    public AstIdent stripRanges() {
        return new AstIdent(PositionRange.UNKNOWN, ident);
    }

    public String getIdent() {
        return ident;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstIdent astIdent = (AstIdent) o;
        return ident.equals(astIdent.ident);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ident);
    }

    @Override
    public String toString() {
        return "AstIdent{" + ident + "}@" + getRange();
    }

}
