package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.labels.InterpolatedString;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstInterpolatedString extends AstValue {
    public final InterpolatedString interpolatedString;

    public AstInterpolatedString(PositionRange range, InterpolatedString interpolatedString) {
        super(range);
        this.interpolatedString = interpolatedString;
    }

    @Override
    public AstInterpolatedString withRange(PositionRange range) {
        return new AstInterpolatedString(range, interpolatedString);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstInterpolatedString that = (AstInterpolatedString) o;
        return interpolatedString.equals(that.interpolatedString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), interpolatedString);
    }

    @Override
    public String toString() {
        return interpolatedString.toString();
    }

}
