package ru.yandex.solomon.expression.ast;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstLambda extends Ast {
    public final List<String> paramNames;
    public final Ast body;

    public AstLambda(PositionRange range, List<String> paramNames, Ast body) {
        super(range);
        this.paramNames = paramNames;
        this.body = body;
    }

    @Override
    public AstLambda withRange(PositionRange range) {
        return new AstLambda(range, paramNames, body);
    }

    @Override
    public AstLambda stripRanges() {
        return new AstLambda(PositionRange.UNKNOWN, paramNames, body.stripRanges());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstLambda astLambda = (AstLambda) o;
        return paramNames.equals(astLambda.paramNames) &&
                body.equals(astLambda.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), paramNames, body);
    }

    @Override
    public String toString() {
        return formatLambda(paramNames, body.toString());
    }

    @Nonnull
    public static String formatLambda(List<String> paramNames, String bodyString) {
        return "(" + String.join(", ", paramNames) + ") -> " + bodyString;
    }

}
