package ru.yandex.solomon.expression.ast;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class AstObject extends Ast {

    private final Map<String, Ast> object;

    public AstObject(PositionRange range, Map<String, Ast> object) {
        super(range);
        this.object = object;
    }

    public Map<String, Ast> getObject() {
        return object;
    }

    @Override
    public AstObject withRange(PositionRange range) {
        return new AstObject(range, object);
    }

    @Override
    public AstObject stripRanges() {
        return new AstObject(PositionRange.UNKNOWN, object.entrySet().stream()
                .map(e -> Map.entry(e.getKey(), e.getValue().stripRanges()))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))
        );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstObject astObject = (AstObject) o;
        return object.equals(astObject.object);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), object);
    }

    @Override
    public String toString() {
        String content = object.entrySet()
            .stream()
            .map(entry -> entry.getKey() + ": " + entry.getValue())
            .collect(Collectors.joining(", "));
        return '{' + content + '}';
    }
}
