package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstOp extends Ast {
    private final String op;

    public AstOp(PositionRange range, String op) {
        super(range);
        this.op = op;
    }

    @Override
    public AstOp withRange(PositionRange range) {
        return new AstOp(range, op);
    }

    @Override
    public AstOp stripRanges() {
        return new AstOp(PositionRange.UNKNOWN, op);
    }

    public String asString() {
        return op;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstOp astOp = (AstOp) o;
        return op.equals(astOp.op);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), op);
    }

    @Override
    public String toString() {
        return "AstOp{" + op + "}@" + getRange();
    }

}
