package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.labels.query.SelectorType;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AstSelector extends Ast {
    private final Ast key;
    private final Ast value;
    private final SelectorType type;

    public AstSelector(PositionRange range, Ast key, Ast value, SelectorType type) {
        super(range);
        this.key = key;
        this.value = value;
        this.type = type;
    }

    @Override
    public AstSelector withRange(PositionRange range) {
        return new AstSelector(range, key, value, type);
    }

    @Override
    public AstSelector stripRanges() {
        return new AstSelector(PositionRange.UNKNOWN, key.stripRanges(), value.stripRanges(), type);
    }

    public Ast getKey() {
        return key;
    }

    public Ast getValue() {
        return value;
    }

    public SelectorType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstSelector that = (AstSelector) o;
        return key.equals(that.key) &&
                value.equals(that.value) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), key, value, type);
    }

    @Override
    public String toString() {
        return key + " " + type.getOperator() + " " + value;
    }
}
