package ru.yandex.solomon.expression.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AstSelectors extends Ast {
    private final String nameSelector;
    private final List<AstSelector> selectors;

    public AstSelectors(PositionRange range, String nameSelector, List<AstSelector> selectors) {
        super(range);
        this.nameSelector = nameSelector;
        this.selectors = selectors;
    }

    @Override
    public AstSelectors withRange(PositionRange range) {
        return new AstSelectors(range, nameSelector, selectors);
    }

    @Override
    public AstSelectors stripRanges() {
        return new AstSelectors(PositionRange.UNKNOWN, nameSelector, selectors.stream()
                .map(AstSelector::stripRanges).collect(Collectors.toList()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstSelectors that = (AstSelectors) o;
        return nameSelector.equals(that.nameSelector) &&
                selectors.equals(that.selectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), nameSelector, selectors);
    }

    @Override
    public String toString() {
        return nameSelector + selectors.stream()
                .map(AstSelector::toString)
                .collect(Collectors.joining(", ", "{", "}"));
    }

    public String getNameSelector() {
        return nameSelector;
    }

    public List<AstSelector> getSelectors() {
        return selectors;
    }
}
