package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstTernaryOp extends Ast {
    private final Ast condition;
    private final Ast left;
    private final Ast right;

    public AstTernaryOp(PositionRange range, Ast condition, Ast left, Ast right) {
        super(range);
        this.condition = condition;
        this.left = left;
        this.right = right;
    }

    public Ast getCondition() {
        return condition;
    }

    public Ast getLeft() {
        return left;
    }

    public Ast getRight() {
        return right;
    }

    @Override
    public AstTernaryOp withRange(PositionRange range) {
        return new AstTernaryOp(range, condition, left, right);
    }

    @Override
    public AstTernaryOp stripRanges() {
        return new AstTernaryOp(PositionRange.UNKNOWN, condition.stripRanges(), left.stripRanges(), right.stripRanges());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstTernaryOp that = (AstTernaryOp) o;
        return condition.equals(that.condition) &&
                left.equals(that.left) &&
                right.equals(that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), condition, left, right);
    }

    @Override
    public String toString() {
        return "AstTernaryOp{" +
            "condition=" + condition +
            ", left=" + left +
            ", right=" + right +
            "}@" + getRange();
    }
}
