package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class AstUnaryOp extends Ast {
    private final Ast param;
    private final AstOp op;

    public AstUnaryOp(PositionRange range, Ast param, AstOp op) {
        super(range);
        this.param = param;
        this.op = op;
    }

    @Override
    public AstUnaryOp withRange(PositionRange range) {
        return new AstUnaryOp(range, param, op);
    }

    @Override
    public AstUnaryOp stripRanges() {
        return new AstUnaryOp(PositionRange.UNKNOWN, param.stripRanges(), op.stripRanges());
    }

    public Ast getParam() {
        return param;
    }

    public AstOp getOp() {
        return op;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstUnaryOp that = (AstUnaryOp) o;
        return param.equals(that.param) &&
                op.equals(that.op);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), param, op);
    }

    @Override
    public String toString() {
        return op.toString() + param;
    }
}
