package ru.yandex.solomon.expression.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstUse extends AstStatement {
    private final List<AstSelector> labelSelectors;

    public AstUse(PositionRange range, List<AstSelector> labelSelectors) {
        super(range);
        this.labelSelectors = labelSelectors;
    }

    public List<AstSelector> getLabelSelectors() {
        return labelSelectors;
    }

    @Override
    public AstUse withRange(PositionRange range) {
        return new AstUse(range, labelSelectors);
    }

    @Override
    public AstUse stripRanges() {
        return new AstUse(PositionRange.UNKNOWN, labelSelectors.stream()
                .map(AstSelector::stripRanges).collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        return "AstUse{" + labelSelectors + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstUse astUse = (AstUse) o;
        return labelSelectors.equals(astUse.labelSelectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), labelSelectors);
    }
}
