package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueDouble extends AstValue {
    private final double value;

    public AstValueDouble(PositionRange range, double value) {
        super(range);
        this.value = value;
    }

    @Override
    public AstValueDouble withRange(PositionRange range) {
        return new AstValueDouble(range, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstValueDouble that = (AstValueDouble) o;
        return Double.compare(that.value, value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), value);
    }

    @Override
    public String toString() {
        return "AstValueDouble{" +
                "value=" + value +
                '}';
    }

    public double getValue() {
        return value;
    }
}
