package ru.yandex.solomon.expression.ast;

import java.time.Duration;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueDuration extends AstValue {
    private final Duration value;

    public AstValueDuration(PositionRange range, Duration value) {
        super(range);
        this.value = value;
    }

    @Override
    public AstValueDuration withRange(PositionRange range) {
        return new AstValueDuration(range, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstValueDuration that = (AstValueDuration) o;
        return value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), value);
    }

    @Override
    public String toString() {
        return "AstValueDuration{" +
                "value=" + value +
                '}';
    }

    public Duration getValue() {
        return value;
    }
}
