package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueInterval extends AstValue {
    private final Interval interval;

    public AstValueInterval(PositionRange range, Interval interval) {
        super(range);
        this.interval = interval;
    }

    @Override
    public AstValueInterval withRange(PositionRange range) {
        return new AstValueInterval(range, interval);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstValueInterval that = (AstValueInterval) o;
        return interval.equals(that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), interval);
    }

    @Override
    public String toString() {
        return "AstValueInterval{" +
                "interval=" + interval +
                '}';
    }

    public Interval getInterval() {
        return interval;
    }
}
