package ru.yandex.solomon.expression.ast;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueString extends AstValue {
    private final String value;
    private final boolean skipQuote;

    public AstValueString(PositionRange range, String value) {
        super(range);
        this.value = value;
        skipQuote = false;
    }

    public AstValueString(PositionRange range, String value, boolean skipQuote) {
        super(range);
        this.value = value;
        this.skipQuote = skipQuote;
    }

    @Override
    public AstValueString withRange(PositionRange range) {
        return new AstValueString(range, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AstValueString that = (AstValueString) o;
        return value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), value);
    }

    @Override
    public String toString() {
        return "AstValueString{" +
                "value='" + value + '\'' +
                '}';
    }

    public String getValue() {
        return value;
    }

    public boolean isSkipQuote() {
        return skipQuote;
    }
}
