package ru.yandex.solomon.expression.ast;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public abstract class RecursiveAstVisitor<C, R> {
    @Nullable
    public R visit(Ast ast, C context) {
        if (ast instanceof AstIdent astIdent) {
            return visitIdent(astIdent, context);
        }
        if (ast instanceof AstInterpolatedString astInterpolatedString) {
            return visitInterpolatedString(astInterpolatedString, context);
        }
        if (ast instanceof AstBinOp astBinOp) {
            return visitBinOp(astBinOp, context);
        }
        if (ast instanceof AstTernaryOp astTernaryOp) {
            return visitTernaryOp(astTernaryOp, context);
        }
        if (ast instanceof AstUnaryOp astUnaryOp) {
            return visitUnaryOp(astUnaryOp, context);
        }
        if (ast instanceof AstCall astCall) {
            return visitCall(astCall, context);
        }
        if (ast instanceof AstValue astValue) {
            return visitValue(astValue, context);
        }
        if (ast instanceof AstSelectors astSelectors) {
            return visitSelectors(astSelectors, context);
        }
        if (ast instanceof AstObject astObject) {
            return visitObject(astObject, context);
        }
        return null;
    }

    protected abstract R visitIdent(AstIdent ast, C context);

    protected abstract R visitInterpolatedString(AstInterpolatedString ast, C context);

    protected abstract R visitBinOp(AstBinOp ast, C context);

    protected abstract R visitTernaryOp(AstTernaryOp ast, C context);

    protected abstract R visitUnaryOp(AstUnaryOp ast, C context);

    protected abstract R visitCall(AstCall ast, C context);

    protected abstract R visitValue(AstValue ast, C context);

    protected abstract R visitSelectors(AstSelectors ast, C context);

    protected abstract R visitObject(AstObject ast, C context);

}
