package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstAnonymous;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstAnonymousMapper implements AstMapper<AstAnonymous> {

    private static final String EXPR_KEY = "expr";

    AstAnonymousMapper() {
    }

    @Override
    public AstAnonymous parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstAnonymous(range, ctx.parse(json.get(EXPR_KEY)));
    }

    @Override
    public void render(AstMappingContext ctx, AstAnonymous ast, ObjectNode json) {
        json.set(EXPR_KEY, ctx.render(ast.getExpr()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstAnonymous ast) {
        return ctx.renderToString(ast.getExpr()) + ";";
    }

    @Override
    public String getType() {
        return "anon";
    }

    @Override
    public Class<AstAnonymous> getAstClass() {
        return AstAnonymous.class;
    }
}
