package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstAssignment;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstAssignmentMapper implements AstMapper<AstAssignment> {

    private static final String VAR_KEY = "var";
    private static final String EXPR_KEY = "expr";

    AstAssignmentMapper() {
    }

    @Override
    public AstAssignment parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstAssignment(range, json.get(VAR_KEY).textValue(), ctx.parse(json.get(EXPR_KEY)));
    }

    @Override
    public void render(AstMappingContext ctx, AstAssignment ast, ObjectNode json) {
        json.put(VAR_KEY, ast.getIdent()).set(EXPR_KEY, ctx.render(ast.getExpr()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstAssignment ast) {
        return "let " + ast.getIdent() + " = " + ctx.renderToString(ast.getExpr()) + ";";
    }

    @Override
    public String getType() {
        return "assign";
    }

    @Override
    public Class<AstAssignment> getAstClass() {
        return AstAssignment.class;
    }
}
