package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstBinOp;
import ru.yandex.solomon.expression.ast.AstOp;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstBinOpMapper implements AstMapper<AstBinOp> {

    private static final String LEFT_KEY = "left";
    private static final String OP_KEY = "op";
    private static final String RIGHT_KEY = "right";

    AstBinOpMapper() {
    }

    @Override
    public AstBinOp parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        Ast left = ctx.parse(json.get(LEFT_KEY));
        Ast right = ctx.parse(json.get(RIGHT_KEY));
        AstOp op = ctx.parse(json.get(OP_KEY));
        return new AstBinOp(range, left, right, op);
    }

    @Override
    public void render(AstMappingContext ctx, AstBinOp ast, ObjectNode node) {
        node.set(OP_KEY, ctx.render(ast.getOp()));
        node.set(LEFT_KEY, ctx.render(ast.getLeft()));
        node.set(RIGHT_KEY, ctx.render(ast.getRight()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstBinOp ast) {
        String joinOp = ast.getOp().asString();
        String leftStr = ctx.renderToStringSubexpression(ast.getLeft());
        String rightStr = ctx.renderToStringSubexpression(ast.getRight());
        return leftStr + " " + joinOp + " " + rightStr;
    }

    @Override
    public String getType() {
        return "binOp";
    }

    @Override
    public Class<AstBinOp> getAstClass() {
        return AstBinOp.class;
    }

    @Override
    public boolean needsParenthesesWhenUsedAsSubexpression() {
        return true;
    }
}
