package ru.yandex.solomon.expression.ast.serialization;

import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstCall;
import ru.yandex.solomon.expression.ast.AstIdent;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstCallMapper implements AstMapper<AstCall> {
    private final static String FUNC_KEY = "func";
    private final static String ARGS_KEY = "args";

    AstCallMapper() {
    }

    @Override
    public AstCall parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        AstIdent func = ctx.parse(json.get(FUNC_KEY));
        return new AstCall(range, func, ctx.parseArray(json.get(ARGS_KEY)));
    }

    @Override
    public void render(AstMappingContext ctx, AstCall ast, ObjectNode node) {
        node.set(FUNC_KEY, ctx.render(ast.getFunc()));
        node.putArray(ARGS_KEY).addAll(ast.args.stream().map(ctx::render).collect(Collectors.toList()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstCall ast) {
        if (ast.getFunc().getIdent().equals("as_vector")) {
            // Render as sugar [arg0, arg1, ..., argN]
            return ast.args.stream()
                    .map(ctx::renderToString)
                    .collect(Collectors.joining(", ", "[", "]"));
        }
        return ast.getFunc().getIdent() + ast.args.stream()
                .map(ctx::renderToString)
                .collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public String getType() {
        return "call";
    }

    @Override
    public Class<AstCall> getAstClass() {
        return AstCall.class;
    }
}
