package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstIdent;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstIdentMapper implements AstMapper<AstIdent> {
    private static final String ID_KEY = "id";

    AstIdentMapper() {
    }

    @Override
    public AstIdent parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstIdent(range, json.get(ID_KEY).textValue());
    }

    @Override
    public void render(AstMappingContext ctx, AstIdent ast, ObjectNode node) {
        node.put(ID_KEY, ast.getIdent());
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstIdent ast) {
        return ast.getIdent();
    }

    @Override
    public String getType() {
        return "id";
    }

    @Override
    public Class<AstIdent> getAstClass() {
        return AstIdent.class;
    }
}
