package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstInterpolatedString;
import ru.yandex.solomon.expression.value.SelValueString;
import ru.yandex.solomon.labels.InterpolatedString;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstInterpolatedStringMapper implements AstMapper<AstInterpolatedString> {
    private static final String VALUE_KEY = "v";

    AstInterpolatedStringMapper() {
    }

    @Override
    public AstInterpolatedString parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstInterpolatedString(range, InterpolatedString.parse(json.get(VALUE_KEY).textValue()));
    }

    @Override
    public void render(AstMappingContext ctx, AstInterpolatedString ast, ObjectNode node) {
        node.put(VALUE_KEY, ast.interpolatedString.format());
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstInterpolatedString ast) {
        return new SelValueString(ast.interpolatedString.format()).format();
    }

    @Override
    public String getType() {
        return "interp";
    }

    @Override
    public Class<AstInterpolatedString> getAstClass() {
        return AstInterpolatedString.class;
    }
}
