package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface AstMapper<T extends Ast> {
    T parse(AstMappingContext ctx, PositionRange range, JsonNode json);

    void render(AstMappingContext ctx, T ast, ObjectNode node);
    String renderToString(AstMappingContext ctx, T ast);
    default boolean needsParenthesesWhenUsedAsSubexpression() {
        return false;
    }

    String getType();
    Class<T> getAstClass();
}
