package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstOp;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstOpMapper implements AstMapper<AstOp> {
    private static final String OP_KEY = "op";

    AstOpMapper() {
    }

    @Override
    public AstOp parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstOp(range, json.get(OP_KEY).textValue());
    }

    @Override
    public void render(AstMappingContext ctx, AstOp ast, ObjectNode node) {
        node.put(OP_KEY, ast.asString());
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstOp ast) {
        return ast.asString();
    }

    @Override
    public String getType() {
        return "op";
    }

    @Override
    public Class<AstOp> getAstClass() {
        return AstOp.class;
    }
}
