package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstSelector;
import ru.yandex.solomon.labels.query.SelectorType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstSelectorMapper implements AstMapper<AstSelector> {
    private static final String LABEL_KEY = "k";
    private static final String LABEL_VALUE = "v";
    private static final String SELECTOR_KEY = "o";

    AstSelectorMapper() {
    }

    @Override
    public AstSelector parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstSelector(range, ctx.parse(json.get(LABEL_KEY)), ctx.parse(json.get(LABEL_VALUE)),
                SelectorType.forOperator(json.get(SELECTOR_KEY).textValue()));
    }

    @Override
    public void render(AstMappingContext ctx, AstSelector ast, ObjectNode node) {
        node.put(SELECTOR_KEY, ast.getType().getOperator());
        node.set(LABEL_KEY, ctx.render(ast.getKey()));
        node.set(LABEL_VALUE, ctx.render(ast.getValue()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstSelector ast) {
        return ctx.renderToString(ast.getKey()) + ast.getType().getOperator() + ctx.renderToString(ast.getValue());
    }

    @Override
    public String getType() {
        return "s";
    }

    @Override
    public Class<AstSelector> getAstClass() {
        return AstSelector.class;
    }
}
