package ru.yandex.solomon.expression.ast.serialization;

import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstSelectors;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstSelectorsMapper implements AstMapper<AstSelectors> {
    private static final String NAME_KEY = "name";
    private static final String SELECTORS_KEY = "selectors";

    AstSelectorsMapper() {
    }

    @Override
    public AstSelectors parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        JsonNode maybeName = json.get(NAME_KEY);
        return new AstSelectors(range,
                maybeName != null ? maybeName.textValue() : "",
                ctx.parseArray(json.get(SELECTORS_KEY)));
    }

    @Override
    public void render(AstMappingContext ctx, AstSelectors ast, ObjectNode node) {
        if (!ast.getNameSelector().isEmpty()) {
            node.put(NAME_KEY, ast.getNameSelector());
        }
        node.putArray(SELECTORS_KEY).addAll(ast.getSelectors().stream()
                .map(ctx::render)
                .collect(Collectors.toList())
        );
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstSelectors ast) {
        return ast.getNameSelector() + ast.getSelectors().stream()
                .map(ctx::renderToString)
                .collect(Collectors.joining(", ", "{", "}"));
    }

    @Override
    public String getType() {
        return "selectors";
    }

    @Override
    public Class<AstSelectors> getAstClass() {
        return AstSelectors.class;
    }
}
