package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstTernaryOp;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstTernaryOpMapper implements AstMapper<AstTernaryOp> {
    private static final String COND_KEY = "cond";
    private static final String LEFT_KEY = "left";
    private static final String RIGHT_KEY = "right";

    AstTernaryOpMapper() {
    }

    @Override
    public AstTernaryOp parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        Ast cond = ctx.parse(json.get(COND_KEY));
        Ast left = ctx.parse(json.get(LEFT_KEY));
        Ast right = ctx.parse(json.get(RIGHT_KEY));
        return new AstTernaryOp(range, cond, left, right);
    }

    @Override
    public void render(AstMappingContext ctx, AstTernaryOp ast, ObjectNode node) {
        node.set(COND_KEY, ctx.render(ast.getCondition()));
        node.set(LEFT_KEY, ctx.render(ast.getLeft()));
        node.set(RIGHT_KEY, ctx.render(ast.getRight()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstTernaryOp ast) {
        return ctx.renderToStringSubexpression(ast.getCondition()) + " ? " +
                ctx.renderToStringSubexpression(ast.getLeft()) + " : " +
                ctx.renderToStringSubexpression(ast.getRight());
    }

    @Override
    public String getType() {
        return "tern";
    }

    @Override
    public Class<AstTernaryOp> getAstClass() {
        return AstTernaryOp.class;
    }

    @Override
    public boolean needsParenthesesWhenUsedAsSubexpression() {
        return true;
    }
}
