package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.AstOp;
import ru.yandex.solomon.expression.ast.AstUnaryOp;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstUnaryOpMapper implements AstMapper<AstUnaryOp> {
    private static final String PARAM_KEY = "param";
    private static final String OP_KEY = "op";

    AstUnaryOpMapper() {
    }

    @Override
    public AstUnaryOp parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        AstOp op = ctx.parse(json.get(OP_KEY));
        Ast param = ctx.parse(json.get(PARAM_KEY));
        return new AstUnaryOp(range, param, op);
    }

    @Override
    public void render(AstMappingContext ctx, AstUnaryOp ast, ObjectNode node) {
        node.set(OP_KEY, ctx.render(ast.getOp()));
        node.set(PARAM_KEY, ctx.render(ast.getParam()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstUnaryOp ast) {
        return ast.getOp().asString() + ctx.renderToStringSubexpression(ast.getParam());
    }

    @Override
    public String getType() {
        return "unary";
    }

    @Override
    public Class<AstUnaryOp> getAstClass() {
        return AstUnaryOp.class;
    }

    @Override
    public boolean needsParenthesesWhenUsedAsSubexpression() {
        return true;
    }
}
