package ru.yandex.solomon.expression.ast.serialization;

import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstUse;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstUseMapper implements AstMapper<AstUse> {
    private static final String SELECTORS_KEY = "selectors";

    AstUseMapper() {
    }

    @Override
    public AstUse parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstUse(range, ctx.parseArray(json.get(SELECTORS_KEY)));
    }

    @Override
    public void render(AstMappingContext ctx, AstUse ast, ObjectNode node) {
        node.putArray(SELECTORS_KEY).addAll(ast.getLabelSelectors().stream()
                .map(ctx::render)
                .collect(Collectors.toList()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstUse ast) {
        return "use {" + ast.getLabelSelectors().stream()
                .map(ctx::renderToString)
                .collect(Collectors.joining(", ")) + "};";
    }

    @Override
    public String getType() {
        return "use";
    }

    @Override
    public Class<AstUse> getAstClass() {
        return AstUse.class;
    }
}
