package ru.yandex.solomon.expression.ast.serialization;

import java.text.DecimalFormat;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstValueDouble;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueDoubleMapper implements AstMapper<AstValueDouble> {
    private static final String VALUE_KEY = "v";

    @Override
    public AstValueDouble parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstValueDouble(range, json.get(VALUE_KEY).doubleValue());
    }

    @Override
    public void render(AstMappingContext ctx, AstValueDouble ast, ObjectNode node) {
        node.put(VALUE_KEY, ast.getValue());
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstValueDouble ast) {
        double value = ast.getValue();
        if ((value % 1d) == 0) {
            return new DecimalFormat("#.#").format(value);
        }
        return Double.toString(value);
    }

    @Override
    public String getType() {
        return "num";
    }

    @Override
    public Class<AstValueDouble> getAstClass() {
        return AstValueDouble.class;
    }
}
