package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstValueDuration;
import ru.yandex.solomon.expression.parser.DurationParser;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueDurationMapper implements AstMapper<AstValueDuration> {
    private static final String VALUE_KEY = "v";

    @Override
    public AstValueDuration parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstValueDuration(range, DurationParser.parseDuration(json.get(VALUE_KEY).textValue()));
    }

    @Override
    public void render(AstMappingContext ctx, AstValueDuration ast, ObjectNode node) {
        node.put(VALUE_KEY, DurationParser.formatDuration(ast.getValue()));
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstValueDuration ast) {
        return DurationParser.formatDuration(ast.getValue());
    }

    @Override
    public String getType() {
        return "dur";
    }

    @Override
    public Class<AstValueDuration> getAstClass() {
        return AstValueDuration.class;
    }
}
