package ru.yandex.solomon.expression.ast.serialization;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.AstValueString;
import ru.yandex.solomon.expression.value.SelValueString;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AstValueStringMapper implements AstMapper<AstValueString> {
    private static final String VALUE_KEY = "v";

    @Override
    public AstValueString parse(AstMappingContext ctx, PositionRange range, JsonNode json) {
        return new AstValueString(range, json.get(VALUE_KEY).textValue());
    }

    @Override
    public void render(AstMappingContext ctx, AstValueString ast, ObjectNode node) {
        node.put(VALUE_KEY, ast.getValue());
    }

    @Override
    public String renderToString(AstMappingContext ctx, AstValueString ast) {
        return new SelValueString(ast.getValue(), ast.isSkipQuote()).format();
    }

    @Override
    public String getType() {
        return "str";
    }

    @Override
    public Class<AstValueString> getAstClass() {
        return AstValueString.class;
    }
}
