package ru.yandex.solomon.expression.compile;

import java.util.Map;
import java.util.NoSuchElementException;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.type.SelType;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class CompileContext {
    private final Map<String, SelType> params;
    private final DeprOpts deprOpts;

    public CompileContext(Map<String, SelType> params) {
        this(params, DeprOpts.DEFAULT);
    }

    public CompileContext(Map<String, SelType> params, DeprOpts deprOpts) {
        this.params = params;
        this.deprOpts = deprOpts;
    }

    public SelType getType(String name) {
        SelType selType = params.get(name);
        if (selType != null) {
            return selType;
        }
        throw new NoSuchElementException("variable '" + name + "' not found, available variables: " + params.keySet());
    }

    public Map<String, SelType> getParams() {
        return params;
    }

    public DeprOpts getDeprOpts() {
        return deprOpts;
    }

    void addVar(String ident, SelType type) {
        params.put(ident, type);
    }
}
