package ru.yandex.solomon.expression.compile;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DeprOpts {

    private static final DeprOpts DROP_ALL = new DeprOpts(true, true);
    public static final DeprOpts DEFAULT = new DeprOpts(false, false);
    private static final DeprOpts DROP_LOAD = new DeprOpts(true, false);
    private static final DeprOpts DROP_LOAD1 = new DeprOpts(false, true);

    public static final DeprOpts GRAFANA = DROP_LOAD1;
    public static final DeprOpts DATA_API = DROP_LOAD;
    public static final DeprOpts ALERTING = DROP_LOAD;
    public static final DeprOpts DATA_API_V3 = DROP_ALL;

    private final boolean dropLoad;
    private final boolean dropLoad1;

    private DeprOpts(boolean dropLoad, boolean dropLoad1) {
        this.dropLoad = dropLoad;
        this.dropLoad1 = dropLoad1;
    }

    boolean isDropLoad() {
        return dropLoad;
    }

    boolean isDropLoad1() {
        return dropLoad1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DeprOpts deprOpts = (DeprOpts) o;

        if (dropLoad != deprOpts.dropLoad) {
            return false;
        }
        if (dropLoad1 != deprOpts.dropLoad1) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = (dropLoad ? 1 : 0);
        result = 31 * result + (dropLoad1 ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DeprOpts{" +
                "dropLoad=" + dropLoad +
                ", dropLoad1=" + dropLoad1 +
                '}';
    }
}
