package ru.yandex.solomon.expression.compile;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.expr.EvalContextImpl;
import ru.yandex.solomon.expression.expr.SelExpr;
import ru.yandex.solomon.expression.expr.SelExprVisitor;
import ru.yandex.solomon.expression.value.SelValueSideEffect;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelAnonymous implements SelStatement {
    private final PositionRange range;
    private final SelExpr expr;

    SelAnonymous(PositionRange range, SelExpr expr) {
        this.range = range;
        this.expr = expr;
    }

    @Override
    public PositionRange getRange() {
        return range;
    }

    public SelExpr getExpr() {
        return expr;
    }

    @Override
    public String format() {
        return expr.format() + ";";
    }

    @Override
    public SelStatement visit(SelExprVisitor visitor)  {
        return new SelAnonymous(range, expr.visit(visitor));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelAnonymous that = (SelAnonymous) o;

        if (!this.getExpr().equals(that.getExpr())) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return expr.hashCode();
    }

    @Override
    public String toString() {
        return format();
    }

    @Override
    public void changeCompileContext(CompileContext compiler) {
        // no-op
    }

    @Override
    public boolean changeEvalContext(EvalContextImpl context) {
        if (!expr.type().isSideEffect()) {
            return false;
        }
        SelValueSideEffect sideEffect = (SelValueSideEffect) expr.eval(context);
        context.process(sideEffect);
        return sideEffect.isTerminating();
    }
}
