package ru.yandex.solomon.expression.compile;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.expr.EvalContextImpl;
import ru.yandex.solomon.expression.expr.SelExprSelector;
import ru.yandex.solomon.expression.expr.SelExprVisitor;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class SelUse implements SelStatement {
    private final PositionRange range;
    private final List<SelExprSelector> selectors;

    SelUse(PositionRange range, List<SelExprSelector> selectors) {
        this.range = range;
        this.selectors = selectors;
    }

    @Override
    public PositionRange getRange() {
        return range;
    }

    public List<SelExprSelector> getSelectors() {
        return selectors;
    }

    @Override
    public SelUse visit(SelExprVisitor visitor) {
        List<SelExprSelector> patched = selectors.stream()
                .map(visitor::visitSelector)
                .collect(Collectors.toList());
        return new SelUse(range, patched);
    }

    @Override
    public void changeCompileContext(CompileContext compiler) {
        // no-op
    }

    @Override
    public boolean changeEvalContext(EvalContextImpl interpreter) {
        return false;
    }

    @Override
    public String format() {
        return "use " + selectors.stream()
                .map(SelExprSelector::toString)
                .collect(Collectors.joining(", "))
                + ";";
    }

    @Override
    public String toString() {
        return format();
    }
}
