package ru.yandex.solomon.expression.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.SelLexer;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ParserException extends SelException {
    private final static String STAGE = "parsing";

    public ParserException(boolean astUseRanges, SelLexer.ScannedToken failingToken, String message) {
        super(failingToken.getRange(astUseRanges), STAGE, message);
    }

    public ParserException(boolean astUseRanges, SelLexer.ScannedToken failingToken, Throwable t) {
        super(failingToken.getRange(astUseRanges), STAGE, t);
    }
}
