package ru.yandex.solomon.expression.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.compile.SelStatement;
import ru.yandex.solomon.expression.compile.SelUse;
import ru.yandex.solomon.expression.exceptions.CompilerException;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AppendUseToSelectors extends SelExprRecurseVisitor {
    private final List<SelExprSelector> currentUseSelectors;

    private AppendUseToSelectors(List<SelExprSelector> currentUseSelectors) {
        this.currentUseSelectors = currentUseSelectors;
    }

    public static List<SelStatement> fillUse(List<SelStatement> code) {
        List<SelExprSelector> currentUseSelectors = List.of();
        List<SelStatement> patched = new ArrayList<>(code.size());

        for (SelStatement line : code) {
            if (line instanceof SelUse use) {
                currentUseSelectors = use.getSelectors();
            } else {
                AppendUseToSelectors visitor = new AppendUseToSelectors(currentUseSelectors);
                patched.add(line.visit(visitor));
            }
        }
        return patched;
    }

    @Override
    public SelExpr visitSelectors(SelExprSelectors selectors) {
        List<SelExprSelector> loadQuery = selectors.getSelectors();
        List<SelExprSelector> merged = new ArrayList<>(loadQuery.size() + currentUseSelectors.size());
        Set<String> overrideKeys = loadQuery.stream()
            .map(SelExprSelector::getKey)
            .filter(expr -> expr instanceof SelExprValue)
            .map(expr -> ((SelExprValue) expr).getValue().castToString().getValue())
            .collect(Collectors.toSet());

        for (var useSelector : currentUseSelectors) {
            SelExpr key = useSelector.getKey();
            if (!(key instanceof SelExprValue)) {
                throw new CompilerException(useSelector.getRange(), "Use selector is not constant");
            }
            String keyValue = ((SelExprValue) key).getValue().castToString().getValue();
            // Skip selectors that are defined in the load query
            if (!overrideKeys.contains(keyValue)) {
                merged.add(useSelector);
            }
        }
        merged.addAll(loadQuery);

        return new SelExprSelectors(selectors.getSourceAst(), selectors.type(), selectors.getNameSelector(), merged);
    }
}
