package ru.yandex.solomon.expression.expr;

import java.util.function.UnaryOperator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.solomon.expression.PositionRange;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.exceptions.EvaluationException;
import ru.yandex.solomon.expression.exceptions.SelException;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.value.SelValue;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class SelExpr {
    private static final Logger logger = LoggerFactory.getLogger(SelExpr.class);

    private final Ast sourceAst;

    protected SelExpr(Ast sourceAst) {
        this.sourceAst = sourceAst;
    }

    public Ast getSourceAst() {
        return sourceAst;
    }

    public PositionRange getRange() {
        return getSourceAst().getRange();
    }

    @Nonnull
    public abstract SelType type();
    @Nonnull
    protected abstract SelValue evalInternal(EvalContextImpl context);

    public SelValue eval(EvalContextImpl context) {
        try {
            return evalInternal(context);
        } catch (SelException e) {
            throw e;
        } catch (Throwable t) {
            logger.error("Exception while evaluation", t);
            throw new EvaluationException(getRange(), t);
        }
    }

    @FunctionalInterface
    protected interface ParamsMapper extends UnaryOperator<SelExpr> {
    }

    protected abstract SelExpr mapParams(ParamsMapper f);

    public abstract SelExpr visit(SelExprVisitor visitor);

    public abstract String format();

    @Override
    public abstract boolean equals(@Nullable Object other);

    @Override
    public abstract int hashCode();

    @Override
    public String toString() {
        return format();
    }
}
