package ru.yandex.solomon.expression.expr;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.expression.compile.SelStatement;
import ru.yandex.solomon.math.doubles.AggregateFunctionType;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class SelExprDownSamplingExternalizer {
    private SelExprDownSamplingExternalizer() {
    }

    public static List<SelStatement> fillDownSampling(
            Map<SelExprParam, GraphDataLoadRequest.Builder> extVarToRequest,
            List<SelStatement> block)
    {
        return SelExprFnExternalizeVisitor.replaceFnCall(
            SelExprDownSamplingExternalizer::isDownSampleFn,
            fnCall -> externalizeDownSampling(extVarToRequest, fnCall),
            block
        );
    }

    private static boolean isDownSampleFn(SelExprFuncCall fnCall) {
        return fnCall.getFunc().getName().equals("group_by_time");
    }

    private static SelExpr externalizeDownSampling(
            Map<SelExprParam, GraphDataLoadRequest.Builder> extVarToRequest,
            SelExprFuncCall fnCall)
    {
        SelExpr dataParam = fnCall.getArgs().get(2);
        if (!(dataParam instanceof SelExprParam)) {
            return fnCall;
        }

        GraphDataLoadRequest.Builder builder = extVarToRequest.get(dataParam);
        if (builder == null) {
            return fnCall;
        }

        SelExpr durationParam = fnCall.getArgs().get(0);
        if (!(durationParam instanceof SelExprValue)) {
            return fnCall;
        }

        Duration duration = ((SelExprValue) durationParam).getValue().castToDuration().getDuration();

        SelExpr aggrParam = fnCall.getArgs().get(1);
        if (!(aggrParam instanceof SelExprValue)) {
            return fnCall;
        }
        String aggrParamValue = ((SelExprValue) aggrParam).getValue().castToString().getValue();

        Optional<AggregateFunctionType> aggrFnOpt =
            AggregateFunctionType.byName(aggrParamValue);

        if (aggrFnOpt.isEmpty()) {
            return fnCall;
        }

        builder.setGridMillis(duration.toMillis())
            .setAggregateFunction(aggrFnOpt.get());

        return dataParam;
    }
}
