package ru.yandex.solomon.expression.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.compile.SelStatement;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelExprFnExternalizeVisitor extends SelExprRecurseVisitor {
    private final Predicate<SelExprFuncCall> predicate;
    private final ReplaceFuncCall replace;

    @FunctionalInterface
    public interface ReplaceFuncCall extends Function<SelExprFuncCall, SelExpr> {
    }

    public SelExprFnExternalizeVisitor(Predicate<SelExprFuncCall> predicate, ReplaceFuncCall replace) {
        this.predicate = predicate;
        this.replace = replace;
    }

    public static List<SelStatement> replaceFnCall(
            Predicate<SelExprFuncCall> predicate,
            ReplaceFuncCall replace,
            List<SelStatement> lines)
    {
        SelExprFnExternalizeVisitor visitor = new SelExprFnExternalizeVisitor(predicate, replace);
        List<SelStatement> patched = new ArrayList<>(lines.size());

        for (SelStatement stmt : lines) {
            patched.add(stmt.visit(visitor));
        }

        return patched;
    }

    @Override
    public SelExpr visitFn(SelExprFuncCall fnCall) {
        fnCall = fnCall.mapParams(e -> e.visit(this));
        if (predicate.test(fnCall)) {
            return replace.apply(fnCall);
        }
        return fnCall;
    }
}
