package ru.yandex.solomon.expression.expr;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.AstInterpolatedString;
import ru.yandex.solomon.expression.type.SelTypeString;
import ru.yandex.solomon.expression.type.SelTypes;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueString;
import ru.yandex.solomon.labels.InterpolatedString;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelExprInterpolatedString extends SelExpr {

    public SelExprInterpolatedString(AstInterpolatedString interpolatedString) {
        super(interpolatedString);
    }

    @Override
    public AstInterpolatedString getSourceAst() {
        return (AstInterpolatedString) super.getSourceAst();
    }

    @Nonnull
    @Override
    public SelTypeString type() {
        return SelTypes.STRING;
    }

    @Nonnull
    @Override
    public SelValue evalInternal(EvalContextImpl context) {
        String value = getSourceAst().interpolatedString.partialEval((name) -> {

            SelValue selValue = context.getOrNull(name);

            if (selValue == null) {
                return Optional.empty();
            }

            return Optional.of(selValue.convertToString());
        }).format();
        return new SelValueString(value);
    }

    @Override
    protected SelExpr mapParams(ParamsMapper f) {
        return this;
    }

    @Override
    public SelExpr visit(SelExprVisitor visitor) {
        return visitor.visitInterpolatedString(this);
    }

    @Override
    public String format() {
        return new SelValueString(getSourceAst().interpolatedString.format()).format();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelExprInterpolatedString that = (SelExprInterpolatedString) o;
        InterpolatedString thisInterpolatedString = this.getSourceAst().interpolatedString;
        InterpolatedString thatInterpolatedString = that.getSourceAst().interpolatedString;
        return thisInterpolatedString.equals(thatInterpolatedString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(getSourceAst().interpolatedString);
    }
}
