package ru.yandex.solomon.expression.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.compile.SelStatement;
import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class SelExprLoadExternalizer {
    private SelExprLoadExternalizer() {
    }

    public static ExternalizedResult externalizeLoad(List<SelStatement> lines, boolean useNewFormat) {
        SelExprSelectorsReplaceVisitor visitor = new SelExprSelectorsReplaceVisitor(useNewFormat);
        List<SelStatement> patched = new ArrayList<>(lines.size());
        for (SelStatement statement : lines) {
            patched.add(statement.visit(visitor));
        }

        return new ExternalizedResult(visitor.getSelectorByParam(), patched);
    }

    public static class ExternalizedResult {
        private final Map<SelExprParam, Selectors> externalParamToSelector;
        private final List<SelStatement> patchedLines;

        public ExternalizedResult(Map<SelExprParam, Selectors> externalParamToSelector, List<SelStatement> patchedLines) {
            this.externalParamToSelector = externalParamToSelector;
            this.patchedLines = patchedLines;
        }

        public Map<SelExprParam, Selectors> getExternalParamToSelector() {
            return externalParamToSelector;
        }

        public List<SelStatement> getPatchedLines() {
            return patchedLines;
        }
    }
}
