package ru.yandex.solomon.expression.expr;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.ast.AstIdent;
import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.value.SelValue;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelExprParam extends SelExpr {
    private final String name;
    private final SelType type;

    public SelExprParam(AstIdent ident, SelType type) {
        super(ident);
        this.name = ident.getIdent();
        this.type = type;
    }

    @Override
    public AstIdent getSourceAst() {
        return (AstIdent) super.getSourceAst();
    }

    public String getName() {
        return name;
    }

    @Nonnull
    @Override
    public SelType type() {
        return type;
    }

    @Nonnull
    @Override
    public SelValue evalInternal(EvalContextImpl context) {
        return context.getOrThrow(name);
    }

    @Override
    protected SelExprParam mapParams(ParamsMapper f) {
        return this;
    }

    @Override
    public SelExpr visit(SelExprVisitor visitor) {
        return visitor.visitParam(this);
    }

    @Override
    public String format() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelExprParam that = (SelExprParam) o;
        return name.equals(that.name) &&
            type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, type);
    }
}
